

<?php $__env->startSection('title', 'Prescriptions Report'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="mb-6 flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4">
        <div>
            <h1 class="text-3xl font-bold text-gray-800">Prescriptions Report</h1>
            <p class="text-gray-600 mt-1">Detailed prescription analytics and statistics</p>
        </div>
        <a href="<?php echo e(route('admin.reports.index')); ?>" class="text-blue-600 hover:text-blue-800">
            <i class="fas fa-arrow-left mr-2"></i>Back to Reports
        </a>
    </div>

    <!-- Date Filter -->
    <div class="bg-white rounded-lg shadow p-6 mb-6">
        <form method="GET" action="<?php echo e(route('admin.reports.prescriptions')); ?>" class="flex flex-col sm:flex-row gap-4">
            <div class="flex-1">
                <label class="block text-sm font-medium text-gray-700 mb-2">Start Date</label>
                <input type="date" name="start_date" value="<?php echo e($startDate); ?>" class="w-full px-3 py-2 border rounded">
            </div>
            <div class="flex-1">
                <label class="block text-sm font-medium text-gray-700 mb-2">End Date</label>
                <input type="date" name="end_date" value="<?php echo e($endDate); ?>" class="w-full px-3 py-2 border rounded">
            </div>
            <div class="flex items-end">
                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded">
                    Filter
                </button>
            </div>
            <div class="flex items-end">
                <a href="<?php echo e(route('admin.reports.export-prescriptions', ['start_date' => $startDate, 'end_date' => $endDate])); ?>" 
                   class="bg-green-600 hover:bg-green-700 text-white px-6 py-2 rounded">
                    <i class="fas fa-download mr-2"></i>Export CSV
                </a>
            </div>
        </form>
    </div>

    <!-- Statistics Cards -->
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6 mb-6">
        <div class="bg-gradient-to-br from-blue-500 to-blue-600 rounded-lg shadow-lg p-6 text-white">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-blue-100 text-sm">Total Prescriptions</p>
                    <p class="text-3xl font-bold mt-2"><?php echo e($stats['total']); ?></p>
                </div>
                <i class="fas fa-prescription text-4xl opacity-50"></i>
            </div>
        </div>

        <div class="bg-gradient-to-br from-green-500 to-green-600 rounded-lg shadow-lg p-6 text-white">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-green-100 text-sm">This Month</p>
                    <p class="text-3xl font-bold mt-2"><?php echo e($stats['this_month']); ?></p>
                </div>
                <i class="fas fa-calendar-alt text-4xl opacity-50"></i>
            </div>
        </div>

        <div class="bg-gradient-to-br from-purple-500 to-purple-600 rounded-lg shadow-lg p-6 text-white">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-purple-100 text-sm">Last Month</p>
                    <p class="text-3xl font-bold mt-2"><?php echo e($stats['last_month']); ?></p>
                </div>
                <i class="fas fa-history text-4xl opacity-50"></i>
            </div>
        </div>

        <div class="bg-gradient-to-br from-indigo-500 to-indigo-600 rounded-lg shadow-lg p-6 text-white">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-indigo-100 text-sm">This Year</p>
                    <p class="text-3xl font-bold mt-2"><?php echo e($stats['this_year']); ?></p>
                </div>
                <i class="fas fa-calendar text-4xl opacity-50"></i>
            </div>
        </div>
    </div>

    <!-- Charts -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-6">
        <!-- Daily Prescriptions Chart -->
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-xl font-bold mb-4">Daily Prescriptions Trend</h3>
            <canvas id="dailyChart" height="100"></canvas>
        </div>

        <!-- Prescriptions by Doctor -->
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-xl font-bold mb-4">Top Prescribing Doctors</h3>
            <canvas id="doctorChart" height="100"></canvas>
        </div>
    </div>

    <!-- Prescriptions Table -->
    <div class="bg-white rounded-lg shadow overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-xl font-bold">Recent Prescriptions</h3>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Prescription #</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Doctor</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Patient</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Diagnosis</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Items</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__empty_1 = true; $__currentLoopData = $prescriptions->take(20); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prescription): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="hover:bg-gray-50">
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium"><?php echo e($prescription->prescription_number); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm"><?php echo e($prescription->created_at->format('M d, Y')); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm"><?php echo e($prescription->doctor ? $prescription->doctor->full_name : 'N/A'); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm"><?php echo e($prescription->patient ? $prescription->patient->full_name : 'N/A'); ?></td>
                        <td class="px-6 py-4 text-sm"><?php echo e(\Illuminate\Support\Str::limit($prescription->diagnosis ?? 'N/A', 30)); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm"><?php echo e($prescription->items->count()); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="6" class="px-6 py-4 text-center text-gray-500">No prescriptions found</td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // Daily Prescriptions Chart
    const dailyCtx = document.getElementById('dailyChart').getContext('2d');
    const dailyData = <?php echo json_encode($dailyData, 15, 512) ?>;
    
    new Chart(dailyCtx, {
        type: 'line',
        data: {
            labels: dailyData.map(d => new Date(d.date).toLocaleDateString()),
            datasets: [{
                label: 'Prescriptions',
                data: dailyData.map(d => d.count),
                borderColor: 'rgb(59, 130, 246)',
                backgroundColor: 'rgba(59, 130, 246, 0.1)',
                tension: 0.4,
                fill: true
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    // Top Doctors Chart
    const doctorCtx = document.getElementById('doctorChart').getContext('2d');
    const doctorData = <?php echo json_encode($byDoctor, 15, 512) ?>;
    
    new Chart(doctorCtx, {
        type: 'bar',
        data: {
            labels: doctorData.map(d => d.doctor_name),
            datasets: [{
                label: 'Prescriptions',
                data: doctorData.map(d => d.count),
                backgroundColor: [
                    'rgba(34, 197, 94, 0.8)',
                    'rgba(59, 130, 246, 0.8)',
                    'rgba(168, 85, 247, 0.8)',
                    'rgba(236, 72, 153, 0.8)',
                    'rgba(251, 146, 60, 0.8)',
                ]
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: true,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\BrainTech\Documents\BEAUTEZ SYSTEM\resources\views/admin/reports/prescriptions.blade.php ENDPATH**/ ?>